package view;

import java.awt.GridLayout;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import model.ProxyEvent;
import control.FilterListener;

public class FilterExpPanel extends JPanel {

	private String[] PLACES = new String[] { "Tutti", "Austria", "Italia",
			"Francia", "Spagna", "Inghilterra", "Russia", "Germania/Prussia",
			"Altro" };
	private JComboBox<String> box = new JComboBox<String>(PLACES);

	private static final long serialVersionUID = 1L;
	private ProxyEvent event;

	public FilterExpPanel(ProxyEvent event) {
		this.event = event;

		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new GridLayout(1, 2));

		JButton button = new JButton("Filtra");
		JButton export = new JButton("Esporta");

		add(this.box);
		add(button);
		add(export);

		FilterListener listener = new FilterListener(this.event, box);
		box.addActionListener(listener);
		export.addActionListener(listener);
	}
}
